/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import net.ftb.gui.LaunchFrame;
import net.ftb.locale.I18N;
import net.ftb.tools.ModManager;
import net.ftb.util.SwingUtils;

public class ModpackUpdateDialog
extends JDialog {
    private JLabel messageLbl;
    private JLabel updateLbl;
    private JButton update;
    private JButton abort;
    private JCheckBox backupCFG;
    private JCheckBox backupSave;

    public ModpackUpdateDialog(LaunchFrame instance, boolean modal) {
        super((Frame)instance, modal);
        this.setupGui();
        this.update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ModManager.update = true;
                ModManager.backupCFG = ModpackUpdateDialog.this.backupCFG.isSelected();
                ModManager.backupSave = ModpackUpdateDialog.this.backupSave.isSelected();
                ModpackUpdateDialog.this.setVisible(false);
            }
        });
        this.abort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ModManager.update = false;
                ModpackUpdateDialog.this.setVisible(false);
            }
        });
    }

    private void setupGui() {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/logo_ftb.png")));
        this.setTitle(I18N.getLocaleString("UPDATEMODPACK_TITLE"));
        this.setResizable(false);
        Container panel = this.getContentPane();
        SpringLayout layout = new SpringLayout();
        panel.setLayout(layout);
        this.messageLbl = new JLabel(I18N.getLocaleString("UPDATEMODPACK_ISAVALIBLE"));
        this.updateLbl = new JLabel(I18N.getLocaleString("UPDATE_WICHUPDATE"));
        this.backupCFG = new JCheckBox(I18N.getLocaleString("UPDATEMODPACK_BACKUPCFG"));
        this.backupSave = new JCheckBox(I18N.getLocaleString("UPDATEMODPACK_BACKUPSAVE"));
        this.update = new JButton(I18N.getLocaleString("MAIN_YES"));
        this.abort = new JButton(I18N.getLocaleString("MAIN_NO"));
        this.messageLbl.setHorizontalAlignment(0);
        this.updateLbl.setHorizontalAlignment(0);
        this.backupCFG.setHorizontalAlignment(0);
        this.backupSave.setHorizontalAlignment(0);
        panel.add(this.messageLbl);
        panel.add(this.updateLbl);
        panel.add(this.backupCFG);
        panel.add(this.backupSave);
        panel.add(this.update);
        panel.add(this.abort);
        Spring hSpring = Spring.constant(10);
        layout.putConstraint("West", (Component)this.messageLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.updateLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.backupCFG, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.backupSave, hSpring, "West", (Component)panel);
        Spring columnWidth = SwingUtils.springMax(Spring.width(this.messageLbl), Spring.width(this.updateLbl), Spring.width(this.backupCFG), Spring.width(this.backupSave));
        hSpring = Spring.sum(hSpring, columnWidth);
        layout.putConstraint("East", (Component)this.messageLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.updateLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.backupCFG, hSpring, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.backupSave, hSpring, "West", (Component)panel);
        hSpring = Spring.sum(hSpring, Spring.constant(10));
        layout.putConstraint("East", (Component)panel, hSpring, "West", (Component)panel);
        layout.putConstraint("HorizontalCenter", (Component)this.backupCFG, 0, "HorizontalCenter", (Component)panel);
        layout.putConstraint("HorizontalCenter", (Component)this.backupSave, 0, "HorizontalCenter", (Component)panel);
        layout.putConstraint("East", (Component)this.update, -5, "HorizontalCenter", (Component)panel);
        layout.putConstraint("West", (Component)this.abort, 5, "HorizontalCenter", (Component)panel);
        Spring vSpring = Spring.constant(10);
        layout.putConstraint("North", (Component)this.messageLbl, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.messageLbl), Spring.constant(5));
        layout.putConstraint("North", (Component)this.updateLbl, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.updateLbl), Spring.constant(10));
        layout.putConstraint("North", (Component)this.backupCFG, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.backupCFG), Spring.constant(10));
        layout.putConstraint("North", (Component)this.backupSave, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.backupSave), Spring.constant(10));
        layout.putConstraint("North", (Component)this.update, vSpring, "North", (Component)panel);
        layout.putConstraint("North", (Component)this.abort, vSpring, "North", (Component)panel);
        Spring rowHeight = Spring.max(Spring.height(this.update), Spring.height(this.abort));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(10));
        layout.putConstraint("South", (Component)panel, vSpring, "North", (Component)panel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

